<?php
/* --------------------------------------------------------------
  advanced_search.php 2014-02-11 gm
  Gambio GmbH
  http://www.gambio.de
  Copyright (c) 2014 Gambio GmbH
  Released under the GNU General Public License (Version 2)
  [http://www.gnu.org/licenses/gpl-2.0.html]
  --------------------------------------------------------------


  based on:
  (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
  (c) 2002-2003 osCommerce(advanced_search.php,v 1.49 2003/02/13); www.oscommerce.com
  (c) 2003	 nextcommerce (advanced_search.php,v 1.13 2003/08/21); www.nextcommerce.org
  (c) 2003 XT-Commerce - community made shopping http://www.xt-commerce.com ($Id: advanced_search.php 988 2005-06-18 16:42:42Z mz $)

  Released under the GNU General Public License
  --------------------------------------------------------------------------------------- */

require_once('includes/application_top.php');

$GLOBALS['breadcrumb']->add(NAVBAR_TITLE_ADVANCED_SEARCH, xtc_href_link(FILENAME_ADVANCED_SEARCH));

$coo_advanced_search_view = MainFactory::create_object('AdvancedSearchContentView');
$t_main_content = $coo_advanced_search_view->get_html();

function recursiveIntegerValue($p_variable)
{
    if(is_array($p_variable))
    {
        $c_variable = array();
        
        foreach($p_variable as $t_key => $t_value)
        {
            $c_variable[$t_key] = '';
            if($t_value !== '')
            {
                $c_variable[$t_key] = recursiveIntegerValue($t_value);
            }
        }
    }
    else
    {
        $c_variable = (string)(int)$p_variable;
    }
    
    return $c_variable;
}

function filterIds($p_variable)
{
    if(is_array($p_variable))
    {
        $c_variable = array();
        
        foreach($p_variable as $t_key => $t_value)
        {
            $c_key = (string)(int)$t_key;
            $c_variable[$c_key] = '';
            if($t_value !== '')
            {
                $c_variable[$c_key] = recursiveIntegerValue($t_value);
            }
        }
    }
    else
    {
        $c_variable = preg_replace('/[^0-9&:\|]/', '', (string)$p_variable);
    }
    
    return $c_variable;
}

if(isset($_GET["filter_fv_id"]))
{
    $_GET["filter_fv_id"] = filterIds($_GET["filter_fv_id"]);
}

if(isset($_GET["value_conjunction"]))
{
    $_GET["value_conjunction"] = filterIds($_GET["value_conjunction"]);
}

$coo_layout_control = MainFactory::create_object('LayoutContentControl');
$coo_layout_control->set_data('GET', $_GET);
$coo_layout_control->set_data('POST', $_POST);
$coo_layout_control->set_('coo_breadcrumb', $GLOBALS['breadcrumb']);
$coo_layout_control->set_('coo_product', $GLOBALS['product']);
$coo_layout_control->set_('coo_xtc_price', $GLOBALS['xtPrice']);
$coo_layout_control->set_('c_path', $GLOBALS['cPath']);
$coo_layout_control->set_('main_content', $t_main_content);
$coo_layout_control->set_('request_type', $GLOBALS['request_type']);
$coo_layout_control->proceed();

$t_redirect_url = $coo_layout_control->get_redirect_url();
if(empty($t_redirect_url) === false)
{
	xtc_redirect($t_redirect_url);
}
else
{
	echo $coo_layout_control->get_response();
}
